#ifndef GST_CU_PROFILE_DOWNLOAD_PARAMETERS_HPP_
#define GST_CU_PROFILE_DOWNLOAD_PARAMETERS_HPP_

#include "buildspec.h"

#include "Geometry/SRS.h"

#include <string>

namespace GST
{
namespace ClientUtils
{
class ProfileDownloadParameters
{
public:
	ProfileDownloadParameters(std::string intersectionGeometry,
							  std::string geometryFileType,
							  Geometry::SRSPtr geometrySrs)
		: m_intersectionGeometry(std::move(intersectionGeometry))
		, m_geometryFileType(std::move(geometryFileType))
		, m_geometrySrs(std::move(geometrySrs))
		, m_featureListJsonArray()
		, m_externalBoreholesData()
		, m_profileId(-1)
		, m_digitalTerrainJson()
	{
	}
	const std::string &intersectionGeometry() const
	{
		return m_intersectionGeometry;
	}

	const std::string &geometryFileType() const
	{
		return m_geometryFileType;
	}

	Geometry::SRSPtr geometrySrs() const
	{
		return m_geometrySrs;
	}

	// empty, if not set
	const std::string &featureListJsonArray() const
	{
		return m_featureListJsonArray;
	}

	void setFeatureListJsonArray(std::string featureListJsonArray)
	{
		m_featureListJsonArray = std::move(featureListJsonArray);
	}

	// empty, if not set
	const std::string &externalBoreholesData() const
	{
		return m_externalBoreholesData;
	}

	void setExternalBoreholesData(std::string externalBoreholesData)
	{
		m_externalBoreholesData = std::move(externalBoreholesData);
	}

	// -1, if not set
	long profileId() const
	{
		return m_profileId;
	}

	void setProfileId(const long profileId)
	{
		if(profileId >= 0)
		{
			m_profileId = profileId;
		}
		else
		{
			m_profileId = -1;
		}
	}

	// empty, if not set
	const std::string &digitalTerrainJson() const
	{
		return m_digitalTerrainJson;
	}

	void setDigitalTerrainJson(std::string digitalTerrainJson)
	{
		m_digitalTerrainJson = std::move(digitalTerrainJson);
	}

private:
	// required parameters
	// defines the 2d line string for the request
	std::string m_intersectionGeometry;
	std::string m_geometryFileType;
	Geometry::SRSPtr m_geometrySrs;
	// optional list of feature to intersect
	std::string m_featureListJsonArray;
	// optional boreholes for intersection
	std::string m_externalBoreholesData;
	// optional profile for download
	long m_profileId;
	// optional digital terrain model info for line
	// (yet to be determined how this shall look)
	std::string m_digitalTerrainJson;
};
} // namespace ClientUtils
} // namespace GST

#endif // GST_CU_PROFILE_DOWNLOAD_PARAMETERS_HPP_
